package kochModel.factory;

import kochModel.*;
import lrs.*;
import java.awt.geom.Point2D.Double;

public class Tree1FractalFactory extends FractalFactory {
  
  public Tree1FractalFactory() {
    Double p0 = new Double(0.0,0.0);
    Double p1 = new Double(0.5,0.0);
    Double p2 = new Double(1.0,-1.0/3.0*Math.sqrt(3.0)/2.0);
    Double p3 = new Double(1.0, 1.0/3.0*Math.sqrt(3.0)/2.0);
    
    LRStruct<Koch> children = new LRStruct<Koch>();
    children.insertFront(new Koch(p1, p2));
    children.insertFront(new Koch(p1, p3));
    
    setProto(new Koch(p0, p1, children));
  }
}
